package gov.va.vamf.scheduling.facility.datalayer;

import org.springframework.stereotype.Repository;
import gov.va.vamf.scheduling.facility.domain.CDWFacilities;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class CdwFacilityDataLayer {

	@PersistenceContext(unitName="cdwPersistenceUnit")
    protected EntityManager entityManager;

	private static final String FACILITY_QUERY = "FROM CDWFacilityPo";

	public CDWFacilities fetchFacilities() {
		final TypedQuery<CDWFacilityPo> query = this.entityManager.createQuery(FACILITY_QUERY, CDWFacilityPo.class);
		List<CDWFacilityPo> facilityPos = query.getResultList();

		//this is used to convert the list into CDWFacilities that have additional JSON properties such as size,
		//sort methods, and object type
		CDWFacilities facilitiesResult = new CDWFacilities();

		for(CDWFacilityPo facilityPo : facilityPos) {
			facilitiesResult.add(facilityPo.createFacility());
		}

		return facilitiesResult;
	}
}
